# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    if always_cooperate or always_defect:
        return "D"
    
    # Initial rounds (1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif current_round == 3:
        return "C"
    
    # Mid-game (rounds 4-7)
    if 4 <= current_round <= 7:
        # Check opponent's behavior in first 3 rounds
        opp_first_3 = opp_history[:3]
        coop_count = opp_first_3.count("C")
        if coop_count >= 2:
            # Tit-for-tat
            return opp_history[-1]
        else:
            # Grim trigger
            return "D"
    
    # Late game (rounds 8-10)
    if current_round >= 8:
        # Check opponent's cooperation rate
        coop_rate = opp_history.count("C") / len(opp_history)
        if coop_rate >= 0.7:
            # Tit-for-tat
            return opp_history[-1]
        else:
            # Defect if opponent defected frequently or in final round
            if current_round == 10 or coop_rate <= 0.5:
                return "D"
            else:
                return opp_history[-1]
    
    # Default (shouldn't reach here)
    return "C"